/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.core.v2_1.graphics;

import com.roguewave.chart.core.v2_1.graphics.Canvas3D;
import com.roguewave.chart.core.v2_1.graphics.ClickableDrawable;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Line3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3D;
import com.roguewave.chart.core.v2_1.graphics.SortTreeNode;
import java.awt.Color;
import java.util.Vector;

public class SortTreeLeaf
implements SortTreeNode {
    private Polygon3D[] polygons_;
    private Vector drawables_;
    private Vector clickables_;
    private Vector lines_;

    public SortTreeLeaf() {
        this.polygons_ = new Polygon3D[0];
        this.clickables_ = new Vector();
        this.drawables_ = new Vector();
        this.lines_ = new Vector();
    }

    public SortTreeLeaf(Polygon3D[] polygon3DArray) {
        this.polygons_ = polygon3DArray;
        this.clickables_ = new Vector();
        this.drawables_ = new Vector();
        this.lines_ = new Vector();
    }

    public void addDrawable(Drawable drawable) {
        this.drawables_.addElement(drawable);
    }

    public void addClickable(ClickableDrawable clickableDrawable) {
        this.clickables_.addElement(clickableDrawable);
    }

    public void addLines(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.lines_.addElement(vector.elementAt(n));
            ++n;
        }
    }

    public void addLine(Line3D line3D) {
        this.lines_.addElement(line3D);
    }

    public void addTo(Canvas3D canvas3D) {
        int n = 0;
        while (n < this.polygons_.length) {
            canvas3D.addPolygon(this.polygons_[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.clickables_.size()) {
            canvas3D.addClickable((ClickableDrawable)this.clickables_.elementAt(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.drawables_.size()) {
            canvas3D.addDrawable((Drawable)this.drawables_.elementAt(n3));
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.lines_.size()) {
            canvas3D.addLine((Line3D)this.lines_.elementAt(n4), Color.black);
            ++n4;
        }
    }
}

